/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crank;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.crank.HandCrankBlock;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class HandCrankBlockEntity
extends GeneratingKineticBlockEntity {
    public int inUse;
    public boolean backwards;
    public float independentAngle;
    public float chasingVelocity;

    public HandCrankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void turn(boolean back) {
        boolean update = false;
        if (this.getGeneratedSpeed() == 0.0f || back != this.backwards) {
            update = true;
        }
        this.inUse = 10;
        this.backwards = back;
        if (update && !this.field_11863.field_9236) {
            this.updateGeneratedRotation();
        }
    }

    public float getIndependentAngle(float partialTicks) {
        return (this.independentAngle + partialTicks * this.chasingVelocity) / 360.0f;
    }

    @Override
    public float getGeneratedSpeed() {
        class_2248 block = this.method_11010().method_26204();
        if (!(block instanceof HandCrankBlock)) {
            return 0.0f;
        }
        HandCrankBlock crank = (HandCrankBlock)block;
        int speed = (this.inUse == 0 ? 0 : (this.clockwise() ? -1 : 1)) * crank.getRotationSpeed();
        return HandCrankBlockEntity.convertToDirection(speed, (class_2350)this.method_11010().method_11654((class_2769)HandCrankBlock.FACING));
    }

    protected boolean clockwise() {
        return this.backwards;
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("InUse", this.inUse);
        compound.method_10556("Backwards", this.backwards);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.inUse = compound.method_10550("InUse");
        this.backwards = compound.method_10577("Backwards");
        super.read(compound, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0) {
            --this.inUse;
            if (this.inUse == 0 && !this.field_11863.field_9236) {
                this.sequenceContext = null;
                this.updateGeneratedRotation();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public SuperByteBuffer getRenderedHandle() {
        class_2680 blockState = this.method_11010();
        class_2350 facing = blockState.method_28500((class_2769)HandCrankBlock.FACING).orElse(class_2350.field_11036);
        return CachedBuffers.partialFacing((PartialModel)AllPartialModels.HAND_CRANK_HANDLE, (class_2680)blockState, (class_2350)facing.method_10153());
    }

    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderShaft() {
        return true;
    }

    @Override
    protected class_2248 getStressConfigKey() {
        return AllBlocks.HAND_CRANK.has(this.method_11010()) ? (class_2248)AllBlocks.HAND_CRANK.get() : (class_2248)AllBlocks.COPPER_VALVE_HANDLE.get();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.inUse > 0 && AnimationTickHolder.getTicks() % 10 == 0) {
            if (!AllBlocks.HAND_CRANK.has(this.method_11010())) {
                return;
            }
            AllSoundEvents.CRANKING.playAt(this.field_11863, (class_2382)this.field_11867, (float)this.inUse / 2.5f, 0.65f + (float)(10 - this.inUse) / 10.0f, true);
        }
    }
}

